"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
function buildTableData(df_json) {
    var _a;
    return (_a = df_json['data']) === null || _a === void 0 ? void 0 : _a.map((row, index) => {
        return (react_1.default.createElement("tr", { key: index }, row.map((value, idx) => {
            return react_1.default.createElement("td", { key: index + "-" + idx }, value);
        })));
    });
}
class Mito extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.state = {
            sheetJSON: this.props.sheetJSON,
            codeJSON: this.props.codeJSON,
        };
        setInterval(() => {
            // For now, we simulate an editing event every 10 seconds. 
            console.log("Creating an editing event");
            this.props.send({
                'type': 'edited'
            });
        }, 2000);
    }
    render() {
        return (react_1.default.createElement("div", null,
            react_1.default.createElement("div", { className: "mito-sheet" },
                react_1.default.createElement("table", { id: 'mito-sheet' },
                    react_1.default.createElement("tbody", null, buildTableData(this.props.sheetJSON)))),
            react_1.default.createElement("div", { className: "mito-code" }, this.state.codeJSON['code'])));
    }
}
exports.default = Mito;
//# sourceMappingURL=MitoSheet copy.js.map